﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GlobalConfig 
{
    /// <summary>
    /// 是否开启手机震动
    /// </summary>
    public static bool isEnableShake = true;

    /// <summary>
    /// 是否开启音效
    /// </summary>
    public static bool isEnableSound = true;

    /// <summary>
    /// 是否开启bgm
    /// </summary>
    public static bool isEnableBgm = true;

    /// <summary>
    /// 语言类型
    /// </summary>
    public static LangeType langType;
    public static string VibrationKey = "VibrationKey";//震动Key
    public static string SoundKey = "SoundKey";//音效Key
    public static string BgmKey = "BgmKey";//音乐Key

    public static float NormalWidth = 1080f;
    public static float NormalHeight = 1920f;
    public static float CurRatio = (float)UnityEngine.Screen.height / (float)UnityEngine.Screen.width;
    public static float NormalRatio = NormalHeight / NormalWidth;
    public static float Ratio = CurRatio / NormalRatio;


    public static float CanvaUIScaleX = BattleCtrl.instance.battleUI.gameObject.transform.localScale.x;//uicanva适配大小

    //水果可以切的次数
    public static int FruitMoveTotalNum = 3;

    //通过当前关卡返回总的数量
    public static int TotalNum()
    {
        int varLevel = BattleCtrl.instance.levelManager.CurLevelIndex;
        int num = 0;
        if(varLevel == LevelEnum.levelOneIndex)
        {
            num = 3;
        }
        else if(varLevel == LevelEnum.levelTwoIndex || varLevel == LevelEnum.levelThreeIndex
            || varLevel == LevelEnum.levelFourIndex || varLevel == LevelEnum.levelFiveIndex)
        {
            num = 4;
        }
        else if (varLevel == LevelEnum.levelSixIndex || varLevel == LevelEnum.levelSevenIndex
            || varLevel == LevelEnum.levelEightIndex)
        {
            num = 6;
        }
        else if(varLevel == LevelEnum.levelNineIndex)
        {
            num = 6;
        }
        return num;
    }
    //通过当前关卡返回盒子高度
    public static float BoxHeight()
    {
        int varLevel = BattleCtrl.instance.levelManager.CurLevelIndex;
        float varHeight = 0;
        if (varLevel == LevelEnum.levelOneIndex)
        {
            varHeight = 1.5f;
        }
        else if (varLevel == LevelEnum.levelFourIndex || varLevel == LevelEnum.levelFiveIndex
            || varLevel == LevelEnum.levelSevenIndex)
        {
            varHeight = 1.1f;
        }
        else if (varLevel == LevelEnum.levelTwoIndex || varLevel == LevelEnum.levelThreeIndex)
        {
            varHeight = 1.9f;
        }
        else if(varLevel == LevelEnum.levelSixIndex)
        {
            varHeight = 1.3f;
        }
        else if (varLevel == LevelEnum.levelEightIndex || varLevel == LevelEnum.levelNineIndex)
        {
            varHeight = 4.2f;
        }
        return varHeight;
    }
    //通过当前关卡返回胜利动画名称
    public static string WinAnimatorName()
    {
        int varLevel = BattleCtrl.instance.levelManager.CurLevelIndex;
        string varName = "成功_L4-5";
        if (varLevel == LevelEnum.levelOneIndex)
        {
            varName = "成功_L1";
        }
        else if (varLevel == LevelEnum.levelTwoIndex || varLevel == LevelEnum.levelThreeIndex)
        {
            varName = "成功_L2-3";
        }
        else if (varLevel == LevelEnum.levelSixIndex || varLevel == LevelEnum.levelSevenIndex)
        {
            varName = "成功_L6-7";
        }
        else if (varLevel == LevelEnum.levelEightIndex || varLevel == LevelEnum.levelNineIndex)
        {
            varName = "成功_L8-9";
        }
        return varName;
    }
    //通过当前关卡返回失败动画名称
    public static string FailAnimatorName()
    {
        int varLevel = BattleCtrl.instance.levelManager.CurLevelIndex;
        string varName = "失败_L4-5";
        if (varLevel == LevelEnum.levelOneIndex)
        {
            varName = "失败_L1";
        }
        else if (varLevel == LevelEnum.levelTwoIndex || varLevel == LevelEnum.levelThreeIndex)
        {
            varName = "失败_L2-3";
        }
        else if (varLevel == LevelEnum.levelSixIndex || varLevel == LevelEnum.levelSevenIndex)
        {
            varName = "失败_L6-7";
        }
        else if (varLevel == LevelEnum.levelEightIndex || varLevel == LevelEnum.levelNineIndex)
        {
            varName = "失败_L8-9";
        }
        return varName;
    }
    //通过当前关卡返回z轴最大的位置
    public static float GetMaxPosZ()
    {
        int varLevel = BattleCtrl.instance.levelManager.CurLevelIndex;
        float varPosZ = 0.0f;
        if (varLevel == LevelEnum.levelOneIndex)
        {
        }
        else if (varLevel == LevelEnum.levelTwoIndex || varLevel == LevelEnum.levelThreeIndex)
        {
            varPosZ = -0.7f;
        }
        else if (varLevel == LevelEnum.levelFourIndex || varLevel == LevelEnum.levelFiveIndex)
        {
            varPosZ = 1.0f;
        }
        else if (varLevel == LevelEnum.levelSixIndex)
        {
            varPosZ = 1.0f;
        }
        else if(varLevel == LevelEnum.levelSevenIndex)
        {
            varPosZ = 1.7f;
        }
        else if (varLevel == LevelEnum.levelEightIndex || varLevel == LevelEnum.levelNineIndex)
        {
        }
        return varPosZ;
    }
    //加载第一关默认的水果
    public static void LoadFirstLevelDefaultFruit(Transform parent)
    {
        float varX = parent.localPosition.x;
        float varY = parent.localPosition.y;
        float varZ = parent.localPosition.z;
        for(int i = 0;i<3;i++)
        {
            GameObject varObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.StrawberryObj);
            //varObj.transform.SetParent(parent);
            varObj.transform.localPosition = new Vector3(-0.5f + 0.5f * i + varX, 2.5f+ varY, 0.0f+ varZ);
            varObj.transform.localRotation = Quaternion.identity;
        }
        for (int i = 0; i < 3; i++)
        {
            GameObject varObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.LemonObj);
            //varObj.transform.SetParent(parent);
            varObj.transform.localPosition = new Vector3(-0.5f + 0.5f * i+ varX, 3.0f+ varY, 0.0f+ varZ);
            varObj.transform.localRotation = Quaternion.identity;
        }
    }
    //加载第二关默认的水果
    public static void LoadSecondLevelDefaultFruit(Transform parent)
    {
        float varX = parent.localPosition.x;
        float varY = parent.localPosition.y;
        float varZ = parent.localPosition.z;
        for (int i = 0; i < 3; i++)
        {
            GameObject varObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.StrawberryObj);
            //varObj.transform.SetParent(parent);
            varObj.transform.localPosition = new Vector3(-0.5f + 0.5f * i+ varX, 2.5f+ varY, 0.0f+ varZ);
            varObj.transform.localRotation = Quaternion.identity;
        }
        for (int i = 0; i < 3; i++)
        {
            GameObject varObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.LemonObj);
            //varObj.transform.SetParent(parent);
            varObj.transform.localPosition = new Vector3(-0.5f + 0.5f * i+ varX, 3.0f+ varY, 0.0f+ varZ);
            varObj.transform.localRotation = Quaternion.identity;
        }
        for (int i = 0; i < 3; i++)
        {
            GameObject varObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.OrangeObj);
            //varObj.transform.SetParent(parent);
            varObj.transform.localPosition = new Vector3(-0.5f + 0.5f * i+ varX, 3.5f+ varY, 0.0f+ varZ);
            varObj.transform.localRotation = Quaternion.identity;
        }
    }
    //第一关随机加载水果
    public static void LoadFirstRandomFruit(int num,Transform parent)
    {
        float varX = parent.localPosition.x;
        float varY = parent.localPosition.y;
        float varZ = parent.localPosition.z;
        for (int i = 0; i < num; i++)
        {
            int varRand = Random.Range(0, 2);
            GameObject varObj;
            if (varRand == 0)
            {
                varObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.StrawberryObj);
            }
            else
            {
                varObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.LemonObj);
            }
            //varObj.transform.SetParent(parent);
            varObj.transform.localPosition = new Vector3(-0.5f + 0.5f * (i % 3)+ varX, 2.5f+0.5f*(i / 3)+ varY, 0.0f+ varZ);
            varObj.transform.localRotation = Quaternion.identity;
        }
    }
    //第二关随机加载水果
    public static void LoadSecondRandomFruit(int num, Transform parent)
    {
        float varX = parent.localPosition.x;
        float varY = parent.localPosition.y;
        float varZ = parent.localPosition.z;
        for (int i = 0; i < num; i++)
        {
            int varRand = Random.Range(0, 3);
            GameObject varObj;
            if (varRand == 0)
            {
                varObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.StrawberryObj);
            }
            else if(varRand == 1)
            {
                varObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.LemonObj);
            }
            else
            {
                varObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.OrangeObj);
            }
            //varObj.transform.SetParent(parent);
            varObj.transform.localPosition = new Vector3(-0.5f + 0.5f * (i % 3)+ varX, 2.5f + 0.5f * (i / 3)+ varY, 0.0f+ varZ);
            varObj.transform.localRotation = Quaternion.identity;
        }
    }
}

public enum LangeType
{
    Chinese,
    English
}
public enum FruitType
{
    Orange,
    Strawberry,
    Apple,
    Lemon,
    Watermelon,
}
